##  Overview

- **Primary Use Cases:**
    - Monitoring public clouds
    - Monitoring private networks
- **Unified Solution:**
    - Manage both use cases from a single Secure Cloud Analytics instance
- **Comprehensive Visibility:**
    - Monitors attacks and activity across local, private, public, and hybrid cloud environments

---

## Product Transition

- **End-of-Sale Notice:**
    - Secure Cloud Analytics is merging into Cisco Extended Detection and Response (XDR)
    - Not discontinued; all existing features and integrations remain
    - Secure Cloud Analytics features will continue within the Cisco XDR user interface
- **Cisco XDR Highlights:**
    - Cloud-based platform to simplify security operations
    - Enhances detection, prioritization, and response to advanced threats

---

## Deployment and Telemetry Collection

### General Approach

- **Public Cloud Monitoring:**
    - Delivered as SaaS for public cloud visibility
- **Private Network Monitoring:**
    - Targets smaller private networks

### Cloud-Specific Integration

- **Amazon Web Services (AWS):**
    - Agentless deployment using AWS VPC Flow Logs
    - Read-only access for rapid deployment
    - Integrates with CloudTrail, IAM, Inspector, Lambda, and other AWS telemetry sources
- **Google Cloud Platform (GCP):**
    - Uses GCP VPC Flow Logs for agentless monitoring and rapid deployment
- **Microsoft Azure:**
    - Uses Network Security Group (NSG) Flow Logs version 2
    - Enables agentless deployment via API (setup often under 10 minutes)

---

## Kubernetes Integration

- **Scope:** Works with on-premises, private cloud, and public cloud Kubernetes deployments
- **Visibility:** Monitors AWS, Azure, and GCP Kubernetes environments
- **Deployment:** Lightweight sensor on each node via daemonset (YAML)
- **Monitoring Capabilities:** Tracks container-to-container, pod-to-pod, and node-to-node traffic
- **Elasticity:** Sensors automatically scale with cluster size

---

## Detailed Architecture by Cloud

### AWS

- **Telemetry Sources:** VPC Flow Logs via cross-account roles and APIs
- **Visibility:** Byte/packet stats, IPs, traffic patterns, time-of-day usage
- **Ephemeral Services:** Tracks resources like Lambda, even with changing IPs
- **Additional Data Sources:**
    - AWS CloudTrail (resource/service activity)
    - Amazon Inspector (vulnerability reports)
    - AWS Config (compliance monitoring)

### GCP

- **Telemetry Sources:** GCP VPC Flow Logs via cross-account roles and API
- **Visibility:** Similar metrics as AWS (byte/packet stats, IPs, traffic profiles, usage patterns)
- **Process:** Learns and baselines GCP environments automatically

### Azure

- **Telemetry Source:** NSG Flow Logs version 2 via API
- **Deployment:** No agents or sensors needed; fast deployment
- **Dynamic Environments:** Maintains records of activity for deleted resources

---

## Key Points

- Unified security monitoring for private and public environments
- Agentless, fast deployment using cloud-native logs and APIs
- Integrated with Cisco XDR for enhanced threat detection and response
- Extensive Kubernetes support for cluster traffic visibility

---

## Notes

- **Edge Cases:** Dynamic, ephemeral cloud resources are consistently tracked
- **Support:** No immediate impact from end-of-sale notice; transition is to Cisco XDR interface